#!/usr/bin/python3
 
import tkinter
import tkinter.messagebox
import re

top = tkinter.Tk()

# 定义一个变量,用于存放倒计时的时间
time = "00:20:00"
is_stop = True

# 设置窗口标题
top.title('计时器')

# 设置窗口大小
top.geometry('600x300')
# 设置窗口不可变
top.resizable(False, False)

# 设置图片背景(不会影响到下面的控件)
# image = tkinter.PhotoImage(file='res/bg.png')
# label = tkinter.Label(top, image=image)
# label.place(x=0, y=0, relwidth=1, relheight=1)

# 设置窗口图标
top.iconbitmap('res/icon.ico')

# 窗口设置为顶层窗口
top.attributes('-topmost', True)

# 在画面中显示一个文本
text=tkinter.Label(top,text="倒计时")
# 定义文本的字体和大小
text.config(font=("微软雅黑", 26))
text.pack()

# 定义一个倒计时显示的文本
text2=tkinter.Label(top,text=time,pady=10)
# 定义文本的字体和大小
text2.config(font=("微软雅黑", 44))
text2.pack()

# 定义一个输入框用于输入倒计时的时间
entry=tkinter.Entry(top,font=("微软雅黑", 14),width=20)
entry.insert(0,"00:20:00")
entry.pack()

# 定义一个容器用于存放按钮,水平布局
frame=tkinter.Frame(top,pady=10)
frame.pack()
# 定义一个按钮,用于开始倒计时
button1=tkinter.Button(frame,text="开始",font=("微软雅黑", 12),width=10)
button1.pack(side=tkinter.LEFT)
# 定义一个按钮,用于停止倒计时
button2=tkinter.Button(frame,text="停止",font=("微软雅黑", 12),width=10)
button2.pack(side=tkinter.LEFT)
# 定义一个按钮,用于重置倒计时
button3=tkinter.Button(frame,text="重置",font=("微软雅黑", 12),width=10)
button3.pack(side=tkinter.LEFT)

# 在最底部显示一个文本
text3=tkinter.Label(top,text="本程序由 Boringmj 提供",pady=10)
# 定义文本的字体和大小
text3.config(font=("微软雅黑", 8))
text3.pack(side=tkinter.BOTTOM)

# 定义一个函数,用于更新倒计时的时间
def update_time():
    global is_stop
    global time
    # 如果倒计时为00:00:00,停止倒计时
    if time == "00:00:00":
        is_stop = True
    else:
        # 如果倒计时没有停止
        if not is_stop:
            # 获取当前时间
            h, m, s = time.split(":")
            # 将时间转换为整数
            h, m, s = int(h), int(m), int(s)
            # 如果秒数不为0
            if s != 0:
                # 秒数减1
                s -= 1
            # 如果秒数为0
            else:
                # 秒数重置为59
                s = 59
                # 如果分钟不为0
                if m != 0:
                    # 分钟减1
                    m -= 1
                # 如果分钟为0
                else:
                    # 分钟重置为59
                    m = 59
                    # 如果小时不为0
                    if h != 0:
                        # 小时减1
                        h -= 1
                    # 如果小时为0
                    else:
                        # 停止倒计时
                        is_stop = True
            # 将时间转换为字符串
            h, m, s = str(h), str(m), str(s)
            # 如果小时小于10,在前面补0
            if len(h) == 1:
                h = "0" + h
            # 如果分钟小于10,在前面补0
            if len(m) == 1:
                m = "0" + m
            # 如果秒数小于10,在前面补0
            if len(s) == 1:
                s = "0" + s
            # 更新倒计时的时间
            time = h + ":" + m + ":" + s
            if time == "00:00:00":
                is_stop = True
                tkinter.messagebox.showinfo("提示", "倒计时结束")
    text2.config(text=time)
    # 每隔1000毫秒调用一次update_time函数
    text2.after(1000, update_time)

# 定义一个函数,用于开始倒计时
def start():
    # 开始倒计时
    global is_stop
    is_stop = False

# 定义一个函数,用于停止倒计时
def stop():
    # 停止倒计时
    global is_stop
    is_stop = True

# 定义一个函数,用于重置倒计时
def reset():
    # 重置倒计时
    global is_stop
    global time
    is_stop = True
    # 读取输入框的时间
    time_temp = entry.get()
    # 将“：”替换为“:”
    time_temp = time_temp.replace("：", ":")
    # 如果输入的时间不符合格式
    if not re.match(r"^\d{2}:\d{2}:\d{2}$", time_temp):
        tkinter.messagebox.showerror("提醒", "请输入正确的时间\n格式为: 00:00:00")
        return
    # 立即更新显示的时间
    time = time_temp
    text2.config(text=time)

# 绑定按钮的点击事件
button1.config(command=start)
button2.config(command=stop)
button3.config(command=reset)

# 执行update_time函数
update_time()

# 进入消息循环
top.mainloop()