from audioop import add
from concurrent.futures import thread
import socket,time
from threading import Thread

thread_list={}
user_count=0
user_id=1000

def server():
    global thread_list
    global user_id
    print("正在尝试启动多线程分配服务")
    serversocket=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    #host=socket.gethostname()
    host='0.0.0.0'
    port=1820
    serversocket.bind((host,port))
    serversocket.listen()
    try:
        while True:
            print("等待用户连接")
            clientsocket,addr=serversocket.accept()
            print("用户连接到服务 : "+str(addr))
            is_used=True
            while is_used:
                port+=1
                try:
                    serversocket_temp=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
                    host=socket.gethostname()
                    serversocket_temp.bind((host,port))
                    serversocket_temp.listen()
                    serversocket_temp.close()
                    is_used=False
                except Exception as err:
                    print(str(port)+"端口已被占用,正在尝试寻找新的可用端口")
            print("寻找到可用端口: "+str(port))
            thread_list[port]={}
            user_id+=1
            thread_list[port][0]=Link(port,user_id)
            thread_list[port][1]=Thread(target=thread_list[port][0].link)
            thread_list[port][1].start()
            print('多线程已启动')
            clientsocket.send(str(port).encode("utf-8"))
            clientsocket.close()
            print('本次连接已完成')
    except Exception as err:
        print(err)
        serversocket.close()
        print('正在尝试关闭所有多线程')
        print('正在尝试重启')
        server()

class Link:
    port=0
    serversocket=None
    is_join=False
    clientsocket=None
    addr=None
    user_id=0

    def __init__(self,port,user_id):
        self.port=port
        self.user_id=user_id

    def link(self):
        global user_count
        port=self.port
        print("["+str(port)+"]"+"正在尝试启动服务")
        self.serversocket=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        host=socket.gethostname()
        self.serversocket.bind((host,port))
        self.serversocket.listen()
        print("["+str(port)+"]"+"正在等待用户连接")
        thread=Thread(target=self.link_timeout)
        thread.start()
        self.clientsocket,self.addr=self.serversocket.accept()
        self.is_join=True
        user_count+=1
        print("["+str(port)+"]"+"已有用户接入,服务开始运行\nAddr: "+str(self.addr))
        thread_recv=Thread(target=self.recv)
        thread_recv.start()

    def recv(self):
        global thread_list
        global user_count
        port=self.port
        try:
            if not self.addr is None:
                for key in thread_list:
                    thread_list[key][0].send("["+str(self.addr[0])+"]("+str(self.user_id)+") 已加入聊天("+str(user_count)+")")
            while True:
                if not self.clientsocket is None:
                    msg=self.clientsocket.recv(1024).decode()
                    if msg!="":
                        print("["+str(self.port)+"]"+"收到了一条消息: "+msg)
                        if not self.addr is None:
                            for key in thread_list:
                                thread_list[key][0].send("["+str(self.addr[0])+"]("+str(self.user_id)+"): "+msg)
                                if msg=="/list":
                                    for key1 in thread_list:
                                        thread_list[key][0].send(str(thread_list[key1][0].addr[0])+"("+str(thread_list[key1][0].user_id)+")\t")
                else:
                    print("["+str(self.port)+"]"+"接收消息异常错误,连接丢失!")
        except Exception as err:
            print(err)
            print("["+str(port)+"]"+'接受消息已断开连接')
            user_count-=1
            thread_list.pop(self.port)
            if not self.serversocket is None:
                self.serversocket.close()
            if not self.addr is None:
                for key in thread_list:
                    thread_list[key][0].send("["+str(self.addr[0])+"]("+str(self.user_id)+") 已断开连接("+str(user_count)+")")
    
    def send(self,msg):
        global thread_list
        global user_count
        port=self.port
        try:
            if not self.clientsocket is None:
                print("["+str(self.port)+"]"+"发送了一条消息: "+msg)
                self.clientsocket.send(msg.encode("utf-8"))
            else:
                print("["+str(self.port)+"]"+"发送消息异常错误,连接丢失!")
        except Exception as err:
            print(err)
            print("["+str(port)+"]"+'发送失败')
            user_count-=1
            thread_list.pop(self.port)
            if not self.serversocket is None:
                self.serversocket.close()
            if not self.addr is None:
                for key in thread_list:
                    thread_list[key][0].send("["+str(self.addr[0])+"]("+str(self.user_id)+") 已断开连接("+str(user_count)+")")

    def link_timeout(self):
        global thread_list
        time.sleep(60)
        if self.is_join==False:
            if not self.serversocket is None:
                self.serversocket.close()
            print("["+str(self.port)+"]"+"因超时关闭")
            thread_list.pop(self.port)
        else:
            print("["+str(self.port)+"]"+"已有用户接入,维持当前进程中...")
            

server()