package com.ruoyi.proces.service;

import java.util.List;
import com.ruoyi.proces.domain.TProcess;

/**
 * 工序Service接口
 *
 * @author ruoyi
 * @date 2024-05-07
 */
public interface ITProcessService
{
    /**
     * 查询工序
     *
     * @param id 工序主键
     * @return 工序
     */
    public TProcess selectTProcessById(Long id);

    /**
     * 查询工序列表
     *
     * @param tProcess 工序
     * @return 工序集合
     */
    public List<TProcess> selectTProcessList(TProcess tProcess);

    /**
     * 新增工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    public int insertTProcess(TProcess tProcess);

    /**
     * 修改工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    public int updateTProcess(TProcess tProcess);

    /**
     * 批量删除工序
     *
     * @param ids 需要删除的工序主键集合
     * @return 结果
     */
    public int deleteTProcessByIds(Long[] ids);

    /**
     * 删除工序信息
     *
     * @param id 工序主键
     * @return 结果
     */
    public int deleteTProcessById(Long id);

    /**
     * 批量禁用工序
     *
     * @param ids 需要禁用的工序主键集合
     * @return 结果
     */
    public int disabledTProcessByIds(Long[] ids);

    /**
     * 批量启用工序
     *
     * @param ids 需要启用的工序主键集合
     * @return 结果
     */
    public int enableTProcessByIds(Long[] ids);

    /**
     * 改变状态
     *
     * @param tProcess
     * @return 结果
     */
    public int updateStatus(TProcess tProcess);
}

