import request from '@/utils/request'

// 查询工序列表
export function listProcess(query) {
  return request({
    url: '/information/process/list',
    method: 'get',
    params: query
  })
}

// 查询工序详细
export function getProcess(id) {
  return request({
    url: '/information/process/' + id,
    method: 'get'
  })
}

// 新增工序
export function addProcess(data) {
  return request({
    url: '/information/process',
    method: 'post',
    data: data
  })
}

// 修改工序
export function updateProcess(data) {
  return request({
    url: '/information/process',
    method: 'put',
    data: data
  })
}

// 删除工序
export function delProcess(id) {
  return request({
    url: '/information/process/' + id,
    method: 'delete'
  })
}

// 启用
export function enabled(id) {
  return request({
    url: '/information/process/enable/' + id,
    method: 'delete'
  })
}

// 禁用
export function disabled(id) {
  return request({
    url: '/information/process/disable/' + id,
    method: 'delete'
  })
}

// 状态修改
export function changeStatus(id, status) {
  const data = {
    id,
    status
  }
  return request({
    url: '/information/process/changeStatus',
    method: 'put',
    data: data
  })
}
