package com.ruoyi.proces.service.impl;

import java.util.List;
        import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl; //添加
import com.ruoyi.proces.mapper.TProcessMapper;
import com.ruoyi.proces.domain.TProcess;
import com.ruoyi.proces.service.ITProcessService;

/**
 * 工序Service业务层处理
 *
 * @author ruoyi
 * @date 2024-05-07
 */
@Service
public class TProcessServiceImpl extends ServiceImpl<TProcessMapper, TProcess> implements ITProcessService //修改
{
    @Autowired
    private TProcessMapper tProcessMapper;

    /**
     * 查询工序
     *
     * @param id 工序主键
     * @return 工序
     */
    @Override
    public TProcess selectTProcessById(Long id)
    {
        return tProcessMapper.selectTProcessById(id);
    }

    /**
     * 查询工序列表
     *
     * @param tProcess 工序
     * @return 工序
     */
    @Override
    public List<TProcess> selectTProcessList(TProcess tProcess)
    {
        return tProcessMapper.selectTProcessList(tProcess);
    }

    /**
     * 新增工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    @Override
    public int insertTProcess(TProcess tProcess)
    {
                tProcess.setCreateTime(DateUtils.getNowDate());
            return tProcessMapper.insertTProcess(tProcess);
    }

    /**
     * 修改工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    @Override
    public int updateTProcess(TProcess tProcess)
    {
                tProcess.setUpdateTime(DateUtils.getNowDate());
        return tProcessMapper.updateTProcess(tProcess);
    }

    /**
     * 批量删除工序
     *
     * @param ids 需要删除的工序主键
     * @return 结果
     */
    @Override
    public int deleteTProcessByIds(Long[] ids)
    {
        return tProcessMapper.deleteTProcessByIds(ids);
    }

    /**
     * 删除工序信息
     *
     * @param id 工序主键
     * @return 结果
     */
    @Override
    public int deleteTProcessById(Long id)
    {
        return tProcessMapper.deleteTProcessById(id);
    }


    /**
     * 批量禁用
     *
     * @param id 工序主键
     * @return 结果
     */
    @Override
    public int disabledTProcessByIds(Long[] ids) {
        return tProcessMapper.disabledTProcessByIds(ids);
    }

    /**
     * 批量启用
     *
     * @param id 工序主键
     * @return 结果
     */
    @Override
    public int enableTProcessByIds(Long[] ids) {
        return tProcessMapper.enableTProcessByIds(ids);
    }

    /**
     * 修改状态
     *
     * @param tProcess 工序管理主键
     * @return 结果
     */
    @Override
    public int updateStatus(TProcess tProcess) {
        return tProcessMapper.updateTProcess(tProcess);
    }

}
