package com.ruoyi.proces.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper; //添加
import com.ruoyi.proces.domain.TProcess;

/**
 * 工序Mapper接口
 *
 * @author ruoyi
 * @date 2024-05-07
 */
public interface TProcessMapper extends BaseMapper<TProcess> //修改
{
    /**
     * 查询工序
     *
     * @param id 工序主键
     * @return 工序
     */
    public TProcess selectTProcessById(Long id);

    /**
     * 查询工序列表
     *
     * @param tProcess 工序
     * @return 工序集合
     */
    public List<TProcess> selectTProcessList(TProcess tProcess);

    /**
     * 新增工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    public int insertTProcess(TProcess tProcess);

    /**
     * 修改工序
     *
     * @param tProcess 工序
     * @return 结果
     */
    public int updateTProcess(TProcess tProcess);

    /**
     * 删除工序
     *
     * @param id 工序主键
     * @return 结果
     */
    public int deleteTProcessById(Long id);

    /**
     * 批量删除工序
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTProcessByIds(Long[] ids);

    /**
     * 批量启用工序
     *
     * @param ids 需要启用的数据主键集合
     * @return 结果
     */
    public int enableTProcessByIds(Long[] ids);

    /**
     * 批量禁用工序
     *
     * @param ids 需要禁用的数据主键集合
     * @return 结果
     */
    public int disabledTProcessByIds(Long[] ids);

}
