package com.ruoyi.proces.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.proces.domain.TProcess;
import com.ruoyi.proces.service.ITProcessService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 工序Controller
 *
 * @author ruoyi
 * @date 2024-05-07
 */
@RestController
@RequestMapping("/information/process")
public class TProcessController extends BaseController
{
    @Autowired
    private ITProcessService tProcessService;

/**
 * 查询工序列表
 */
@PreAuthorize("@ss.hasPermi('information:process:list')")
@GetMapping("/list")
    public TableDataInfo list(TProcess tProcess)
    {
        startPage();
        List<TProcess> list = tProcessService.selectTProcessList(tProcess);
        return getDataTable(list);
    }

    /**
     * 导出工序列表
     */
    @PreAuthorize("@ss.hasPermi('information:process:export')")
    @Log(title = "工序", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, TProcess tProcess)
    {
        List<TProcess> list = tProcessService.selectTProcessList(tProcess);
        ExcelUtil<TProcess> util = new ExcelUtil<TProcess>(TProcess.class);
        util.exportExcel(response, list, "工序数据");
    }

    /**
     * 获取工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('information:process:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(tProcessService.selectTProcessById(id));
    }

    /**
     * 新增工序
     */
    @PreAuthorize("@ss.hasPermi('information:process:add')")
    @Log(title = "工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TProcess tProcess)
    {
        return toAjax(tProcessService.insertTProcess(tProcess));
    }

    /**
     * 修改工序
     */
    @PreAuthorize("@ss.hasPermi('information:process:edit')")
    @Log(title = "工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TProcess tProcess)
    {
        return toAjax(tProcessService.updateTProcess(tProcess));
    }

    /**
     * 删除工序
     */
    @PreAuthorize("@ss.hasPermi('information:process:remove')")
    @Log(title = "工序", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tProcessService.deleteTProcessByIds(ids));
    }

    /**
     * 启用
     */
    @PreAuthorize("@ss.hasPermi('information:process:remove')")
    @Log(title = "工序", businessType = BusinessType.UPDATE)
    @DeleteMapping("/disable/{ids}")
    public AjaxResult disable(@PathVariable Long[] ids)
    {
        return toAjax(tProcessService.disabledTProcessByIds(ids));
    }

    /**
     * 禁用
     */
    @PreAuthorize("@ss.hasPermi('information:process:edit')")
    @Log(title = "工序", businessType = BusinessType.UPDATE)
    @DeleteMapping("/enable/{ids}")
    public AjaxResult enable(@PathVariable Long[] ids)
    {
        return toAjax(tProcessService.enableTProcessByIds(ids));
    }

    /**
     * 修改状态
     */
    @PreAuthorize("@ss.hasPermi('information:process:edit')")
    @Log(title = "工序", businessType = BusinessType.UPDATE)
    @PutMapping("/changeStatus")
    public AjaxResult changeStatus(@RequestBody TProcess tProcess) {
        return toAjax(tProcessService.updateStatus(tProcess));
    }

}

