<?php

namespace app\esign\service;

/**
 * E签宝配置类
 * 
 * Class Config
 */
class Config {

    /**
     * 配置项(如需公开请注意脱敏)
     * 
     * @access protected
     * @var array
     * @static
     */
    static protected $config=array(
        'app_id'=>'',
        'app_secret'=>'',
        'env'=>'smlopenapi',
        'org_id'=>'',
        'org_name'=>'',
        'org_license'=>''
    );

    /**
     * 返回配置项的值
     * 
     * @access public
     * @param string $key 配置项
     * @param mixed $default 默认值
     * @return mixed
     * @static
     */
    public static function get(string $key,$default=null){
        return self::$config[$key]??$default;
    }

}